<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ration to Aadhar UID - History</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</head>
<body>

<?php
include('../header.php');

$username = $udata['phone'];

// Create history table if not exists
@mysqli_query($ahk_conn, "CREATE TABLE IF NOT EXISTS ration_to_aadhar_uid_history (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL,
    ration_number VARCHAR(100) NOT NULL,
    api_response TEXT,
    members_count INT(11) DEFAULT 0,
    service_charge DECIMAL(10,2) DEFAULT 0,
    status VARCHAR(50) DEFAULT 'Success',
    date DATETIME DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_username (username),
    INDEX idx_ration (ration_number),
    INDEX idx_date (date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");

// Fetch history
$history_query = mysqli_query($ahk_conn, "SELECT * FROM ration_to_aadhar_uid_history WHERE username='$username' ORDER BY id DESC");
?>

<div class="page-wrapper">
<div class="page-content">
<div class="card">
<div class="card-body">

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4><i class="fas fa-history me-2"></i>Ration to Aadhar UID - History</h4>
    <a href="ration-to-aadhar-uid.php" class="btn btn-primary">
        <i class="fas fa-plus me-1"></i>New Search
    </a>
</div>

<div class="table-responsive">
    <table id="historyTable" class="table table-striped table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Ration Number</th>
                <th>Members</th>
                <th>Service Charge</th>
                <th>Status</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($history_query && mysqli_num_rows($history_query) > 0) {
                while($row = mysqli_fetch_assoc($history_query)) {
                    // Decode the JSON response
                    $api_response = json_decode($row['api_response'], true);
                    
                    // Get status from API response if available
                    $display_status = $row['status'];
                    if (isset($api_response['data']['Status'])) {
                        $display_status = $api_response['data']['Status'];
                    }
                    ?>
                    <tr>
                        <td><?php echo $row['id']; ?></td>
                        <td><strong><?php echo htmlspecialchars($row['ration_number']); ?></strong></td>
                        <td><?php echo $row['members_count']; ?> members</td>
                        <td>₹<?php echo number_format($row['service_charge'], 2); ?></td>
                        <td>
                            <?php if($display_status == 'Success' || $row['status'] == 'Success'): ?>
                                <span class="badge bg-success">Success</span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo htmlspecialchars($display_status); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo date('d/m/Y h:i A', strtotime($row['date'])); ?></td>
                        <td>
                            <button class="btn btn-sm btn-info view-details" data-id="<?php echo $row['id']; ?>" data-response='<?php echo htmlspecialchars($row['api_response'], ENT_QUOTES, 'UTF-8'); ?>'>
                                <i class="fas fa-eye"></i> View
                            </button>
                        </td>
                    </tr>
                    <?php
                }
            } else {
                ?>
                <tr>
                    <td colspan="7" class="text-center">No history found</td>
                </tr>
                <?php
            }
            ?>
        </tbody>
    </table>
</div>

</div>
</div>
</div>
</div>

<!-- View Details Modal -->
<div class="modal fade" id="viewModal" tabindex="-1" aria-labelledby="viewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="viewModalLabel">Ration to Aadhar UID Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="modalBody">
                <!-- Details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
$(document).ready(function() {
    var table = $('#historyTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 25
    });
    
    // Use event delegation for dynamically created elements by DataTable
    $(document).on('click', '.view-details', function() {
        try {
            var response = $(this).attr('data-response');
            if (!response) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'No data available'
                });
                return;
            }
            
            var data = JSON.parse(response);
            var html = '';
            
            if (data && data.data) {
                html += '<div class="mb-3 p-3 bg-light rounded">';
                html += '<h6 class="mb-2"><i class="fas fa-id-card me-2"></i>Ration Number: <span class="text-primary">' + (data.data.rationNumber || 'N/A') + '</span></h6>';
                html += '<h6 class="mb-0"><i class="fas fa-users me-2"></i>Total Members: <span class="text-success">' + (data.data.total_members || 0) + '</span></h6>';
                html += '</div>';
                
                if (data.data.uidNumbers && data.data.uidNumbers.length > 0) {
                    html += '<div class="mb-3">';
                    html += '<h6 class="mb-2"><i class="fas fa-fingerprint me-2"></i>Aadhar Numbers (UID):</h6>';
                    html += '<div class="row g-2">';
                    data.data.uidNumbers.forEach(function(uid, index) {
                        html += '<div class="col-md-6">';
                        html += '<div class="p-2 bg-info bg-opacity-10 rounded border border-info">';
                        html += '<small class="text-muted d-block">UID ' + (index + 1) + '</small>';
                        html += '<code class="text-primary fw-bold">' + uid + '</code>';
                        html += '</div></div>';
                    });
                    html += '</div></div>';
                }
                
                if (data.data.members && data.data.members.length > 0) {
                    html += '<div class="mb-3">';
                    html += '<h6 class="mb-2"><i class="fas fa-users me-2"></i>Family Members Details:</h6>';
                    html += '<div class="table-responsive mt-2">';
                    html += '<table class="table table-bordered table-sm table-hover">';
                    html += '<thead class="table-primary"><tr><th>Sr No</th><th>Name</th><th>Gender</th><th>DOB</th><th>Aadhar (UID)</th><th>Relation</th><th>Father Name</th></tr></thead>';
                    html += '<tbody>';
                    data.data.members.forEach(function(member) {
                        html += '<tr>';
                        html += '<td><span class="badge bg-secondary">' + (member.srno || '') + '</span></td>';
                        html += '<td class="fw-bold">' + (member.Nameof_Family_Member_EN || '') + '</td>';
                        html += '<td><span class="badge bg-' + (member.Gender == 'Male' ? 'primary' : 'danger') + '">' + (member.Gender || '') + '</span></td>';
                        html += '<td>' + (member.DOB || '') + '</td>';
                        html += '<td><code class="text-success fw-bold">' + (member.UIDNo || '') + '</code></td>';
                        html += '<td><span class="badge bg-info">' + (member.RELATION || '') + '</span></td>';
                        html += '<td>' + (member.Father_Name_EN || '') + '</td>';
                        html += '</tr>';
                    });
                    html += '</tbody></table></div></div>';
                }
            } else {
                html = '<div class="alert alert-warning"><i class="fas fa-exclamation-triangle me-2"></i>No details available</div>';
            }
            
            $('#modalBody').html(html);
            var modal = new bootstrap.Modal(document.getElementById('viewModal'));
            modal.show();
            
        } catch (error) {
            console.error('Error parsing response:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Failed to load details. Please try again.'
            });
        }
    });
});
</script>

<?php include('../footer.php'); ?>
</body>
</html>
